/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItem;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceDataSyncResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListResourceDataSyncResponse> {
    private static final SdkField<List<ResourceDataSyncItem>> RESOURCE_DATA_SYNC_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListResourceDataSyncResponse.getter(ListResourceDataSyncResponse::resourceDataSyncItems)).setter(ListResourceDataSyncResponse.setter(Builder::resourceDataSyncItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDataSyncItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDataSyncItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceDataSyncResponse.getter(ListResourceDataSyncResponse::nextToken)).setter(ListResourceDataSyncResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_DATA_SYNC_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceDataSyncItem> resourceDataSyncItems;
    private final String nextToken;

    private ListResourceDataSyncResponse(BuilderImpl builder) {
        super(builder);
        this.resourceDataSyncItems = builder.resourceDataSyncItems;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResourceDataSyncItems() {
        return this.resourceDataSyncItems != null && !(this.resourceDataSyncItems instanceof SdkAutoConstructList);
    }

    public List<ResourceDataSyncItem> resourceDataSyncItems() {
        return this.resourceDataSyncItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDataSyncItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDataSyncResponse)) {
            return false;
        }
        ListResourceDataSyncResponse other = (ListResourceDataSyncResponse)((Object)obj);
        return Objects.equals(this.resourceDataSyncItems(), other.resourceDataSyncItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceDataSyncResponse").add("ResourceDataSyncItems", this.resourceDataSyncItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceDataSyncItems": {
                return Optional.ofNullable(clazz.cast(this.resourceDataSyncItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceDataSyncResponse, T> g) {
        return obj -> g.apply((ListResourceDataSyncResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<ResourceDataSyncItem> resourceDataSyncItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDataSyncResponse model) {
            super(model);
            this.resourceDataSyncItems(model.resourceDataSyncItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceDataSyncItem.Builder> getResourceDataSyncItems() {
            return this.resourceDataSyncItems != null ? (Collection)this.resourceDataSyncItems.stream().map(ResourceDataSyncItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceDataSyncItems(Collection<ResourceDataSyncItem> resourceDataSyncItems) {
            this.resourceDataSyncItems = ResourceDataSyncItemListCopier.copy(resourceDataSyncItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDataSyncItems(ResourceDataSyncItem ... resourceDataSyncItems) {
            this.resourceDataSyncItems(Arrays.asList(resourceDataSyncItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDataSyncItems(Consumer<ResourceDataSyncItem.Builder> ... resourceDataSyncItems) {
            this.resourceDataSyncItems(Stream.of(resourceDataSyncItems).map(c -> (ResourceDataSyncItem)((ResourceDataSyncItem.Builder)ResourceDataSyncItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceDataSyncItems(Collection<ResourceDataSyncItem.BuilderImpl> resourceDataSyncItems) {
            this.resourceDataSyncItems = ResourceDataSyncItemListCopier.copyFromBuilder(resourceDataSyncItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceDataSyncResponse build() {
            return new ListResourceDataSyncResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceDataSyncResponse> {
        public Builder resourceDataSyncItems(Collection<ResourceDataSyncItem> var1);

        public Builder resourceDataSyncItems(ResourceDataSyncItem ... var1);

        public Builder resourceDataSyncItems(Consumer<ResourceDataSyncItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

