/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.CommandPluginStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandPlugin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandPlugin> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::name)).setter(CommandPlugin.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::statusAsString)).setter(CommandPlugin.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::statusDetails)).setter(CommandPlugin.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CommandPlugin.getter(CommandPlugin::responseCode)).setter(CommandPlugin.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<Instant> RESPONSE_START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CommandPlugin.getter(CommandPlugin::responseStartDateTime)).setter(CommandPlugin.setter(Builder::responseStartDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseStartDateTime").build()}).build();
    private static final SdkField<Instant> RESPONSE_FINISH_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CommandPlugin.getter(CommandPlugin::responseFinishDateTime)).setter(CommandPlugin.setter(Builder::responseFinishDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseFinishDateTime").build()}).build();
    private static final SdkField<String> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::output)).setter(CommandPlugin.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::standardOutputUrl)).setter(CommandPlugin.setter(Builder::standardOutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputUrl").build()}).build();
    private static final SdkField<String> STANDARD_ERROR_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::standardErrorUrl)).setter(CommandPlugin.setter(Builder::standardErrorUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorUrl").build()}).build();
    private static final SdkField<String> OUTPUT_S3_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::outputS3Region)).setter(CommandPlugin.setter(Builder::outputS3Region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Region").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::outputS3BucketName)).setter(CommandPlugin.setter(Builder::outputS3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3BucketName").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CommandPlugin.getter(CommandPlugin::outputS3KeyPrefix)).setter(CommandPlugin.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, RESPONSE_CODE_FIELD, RESPONSE_START_DATE_TIME_FIELD, RESPONSE_FINISH_DATE_TIME_FIELD, OUTPUT_FIELD, STANDARD_OUTPUT_URL_FIELD, STANDARD_ERROR_URL_FIELD, OUTPUT_S3_REGION_FIELD, OUTPUT_S3_BUCKET_NAME_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String statusDetails;
    private final Integer responseCode;
    private final Instant responseStartDateTime;
    private final Instant responseFinishDateTime;
    private final String output;
    private final String standardOutputUrl;
    private final String standardErrorUrl;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;

    private CommandPlugin(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.responseCode = builder.responseCode;
        this.responseStartDateTime = builder.responseStartDateTime;
        this.responseFinishDateTime = builder.responseFinishDateTime;
        this.output = builder.output;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
    }

    public String name() {
        return this.name;
    }

    public CommandPluginStatus status() {
        return CommandPluginStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Integer responseCode() {
        return this.responseCode;
    }

    public Instant responseStartDateTime() {
        return this.responseStartDateTime;
    }

    public Instant responseFinishDateTime() {
        return this.responseFinishDateTime;
    }

    public String output() {
        return this.output;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseFinishDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandPlugin)) {
            return false;
        }
        CommandPlugin other = (CommandPlugin)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.responseStartDateTime(), other.responseStartDateTime()) && Objects.equals(this.responseFinishDateTime(), other.responseFinishDateTime()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.standardOutputUrl(), other.standardOutputUrl()) && Objects.equals(this.standardErrorUrl(), other.standardErrorUrl()) && Objects.equals(this.outputS3Region(), other.outputS3Region()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix());
    }

    public String toString() {
        return ToString.builder((String)"CommandPlugin").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("ResponseCode", (Object)this.responseCode()).add("ResponseStartDateTime", (Object)this.responseStartDateTime()).add("ResponseFinishDateTime", (Object)this.responseFinishDateTime()).add("Output", (Object)this.output()).add("StandardOutputUrl", (Object)this.standardOutputUrl()).add("StandardErrorUrl", (Object)this.standardErrorUrl()).add("OutputS3Region", (Object)this.outputS3Region()).add("OutputS3BucketName", (Object)this.outputS3BucketName()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "ResponseStartDateTime": {
                return Optional.ofNullable(clazz.cast(this.responseStartDateTime()));
            }
            case "ResponseFinishDateTime": {
                return Optional.ofNullable(clazz.cast(this.responseFinishDateTime()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "StandardOutputUrl": {
                return Optional.ofNullable(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorUrl": {
                return Optional.ofNullable(clazz.cast(this.standardErrorUrl()));
            }
            case "OutputS3Region": {
                return Optional.ofNullable(clazz.cast(this.outputS3Region()));
            }
            case "OutputS3BucketName": {
                return Optional.ofNullable(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommandPlugin, T> g) {
        return obj -> g.apply((CommandPlugin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String statusDetails;
        private Integer responseCode;
        private Instant responseStartDateTime;
        private Instant responseFinishDateTime;
        private String output;
        private String standardOutputUrl;
        private String standardErrorUrl;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandPlugin model) {
            this.name(model.name);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.responseCode(model.responseCode);
            this.responseStartDateTime(model.responseStartDateTime);
            this.responseFinishDateTime(model.responseFinishDateTime);
            this.output(model.output);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorUrl(model.standardErrorUrl);
            this.outputS3Region(model.outputS3Region);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandPluginStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final Instant getResponseStartDateTime() {
            return this.responseStartDateTime;
        }

        @Override
        public final Builder responseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
            return this;
        }

        public final void setResponseStartDateTime(Instant responseStartDateTime) {
            this.responseStartDateTime = responseStartDateTime;
        }

        public final Instant getResponseFinishDateTime() {
            return this.responseFinishDateTime;
        }

        @Override
        public final Builder responseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
            return this;
        }

        public final void setResponseFinishDateTime(Instant responseFinishDateTime) {
            this.responseFinishDateTime = responseFinishDateTime;
        }

        public final String getOutput() {
            return this.output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public CommandPlugin build() {
            return new CommandPlugin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandPlugin> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(CommandPluginStatus var1);

        public Builder statusDetails(String var1);

        public Builder responseCode(Integer var1);

        public Builder responseStartDateTime(Instant var1);

        public Builder responseFinishDateTime(Instant var1);

        public Builder output(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorUrl(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);
    }
}

