/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateActivationResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, CreateActivationResponse> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateActivationResponse.getter(CreateActivationResponse::activationId)).setter(CreateActivationResponse.setter(Builder::activationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()}).build();
    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateActivationResponse.getter(CreateActivationResponse::activationCode)).setter(CreateActivationResponse.setter(Builder::activationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD, ACTIVATION_CODE_FIELD));
    private final String activationId;
    private final String activationCode;

    private CreateActivationResponse(BuilderImpl builder) {
        super(builder);
        this.activationId = builder.activationId;
        this.activationCode = builder.activationCode;
    }

    public String activationId() {
        return this.activationId;
    }

    public String activationCode() {
        return this.activationCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationResponse)) {
            return false;
        }
        CreateActivationResponse other = (CreateActivationResponse)((Object)obj);
        return Objects.equals(this.activationId(), other.activationId()) && Objects.equals(this.activationCode(), other.activationCode());
    }

    public String toString() {
        return ToString.builder((String)"CreateActivationResponse").add("ActivationId", (Object)this.activationId()).add("ActivationCode", (Object)this.activationCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationId": {
                return Optional.ofNullable(clazz.cast(this.activationId()));
            }
            case "ActivationCode": {
                return Optional.ofNullable(clazz.cast(this.activationCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivationResponse, T> g) {
        return obj -> g.apply((CreateActivationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String activationId;
        private String activationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationResponse model) {
            super(model);
            this.activationId(model.activationId);
            this.activationCode(model.activationCode);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getActivationCode() {
            return this.activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public CreateActivationResponse build() {
            return new CreateActivationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateActivationResponse> {
        public Builder activationId(String var1);

        public Builder activationCode(String var1);
    }
}

