/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchPropertiesListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchPropertiesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchPropertiesResponse> {
    private static final SdkField<List<Map<String, String>>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribePatchPropertiesResponse.getter(DescribePatchPropertiesResponse::properties)).setter(DescribePatchPropertiesResponse.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribePatchPropertiesResponse.getter(DescribePatchPropertiesResponse::nextToken)).setter(DescribePatchPropertiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Map<String, String>> properties;
    private final String nextToken;

    private DescribePatchPropertiesResponse(BuilderImpl builder) {
        super(builder);
        this.properties = builder.properties;
        this.nextToken = builder.nextToken;
    }

    public List<Map<String, String>> properties() {
        return this.properties;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchPropertiesResponse)) {
            return false;
        }
        DescribePatchPropertiesResponse other = (DescribePatchPropertiesResponse)((Object)obj);
        return Objects.equals(this.properties(), other.properties()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchPropertiesResponse").add("Properties", this.properties()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchPropertiesResponse, T> g) {
        return obj -> g.apply((DescribePatchPropertiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<Map<String, String>> properties = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchPropertiesResponse model) {
            super(model);
            this.properties(model.properties);
            this.nextToken(model.nextToken);
        }

        public final Collection<? extends Map<String, String>> getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(Collection<? extends Map<String, String>> properties) {
            this.properties = PatchPropertiesListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Map<String, String> ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        public final void setProperties(Collection<? extends Map<String, String>> properties) {
            this.properties = PatchPropertiesListCopier.copy(properties);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchPropertiesResponse build() {
            return new DescribePatchPropertiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchPropertiesResponse> {
        public Builder properties(Collection<? extends Map<String, String>> var1);

        public Builder properties(Map<String, String> ... var1);

        public Builder nextToken(String var1);
    }
}

