/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.OpsEntityItem;
import software.amazon.awssdk.services.ssm.model.OpsEntityItemMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpsEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpsEntity> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OpsEntity.getter(OpsEntity::id)).setter(OpsEntity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Map<String, OpsEntityItem>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(OpsEntity.getter(OpsEntity::data)).setter(OpsEntity.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsEntityItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Map<String, OpsEntityItem> data;

    private OpsEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    public String id() {
        return this.id;
    }

    public boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public Map<String, OpsEntityItem> data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsEntity)) {
            return false;
        }
        OpsEntity other = (OpsEntity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.data(), other.data());
    }

    public String toString() {
        return ToString.builder((String)"OpsEntity").add("Id", (Object)this.id()).add("Data", this.data()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsEntity, T> g) {
        return obj -> g.apply((OpsEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, OpsEntityItem> data = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsEntity model) {
            this.id(model.id);
            this.data(model.data);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, OpsEntityItem.Builder> getData() {
            return this.data != null ? CollectionUtils.mapValues(this.data, OpsEntityItem::toBuilder) : null;
        }

        @Override
        public final Builder data(Map<String, OpsEntityItem> data) {
            this.data = OpsEntityItemMapCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, OpsEntityItem.BuilderImpl> data) {
            this.data = OpsEntityItemMapCopier.copyFromBuilder(data);
        }

        public OpsEntity build() {
            return new OpsEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpsEntity> {
        public Builder id(String var1);

        public Builder data(Map<String, OpsEntityItem> var1);
    }
}

