/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailureDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailureDetails> {
    private static final SdkField<String> FAILURE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailureDetails.getter(FailureDetails::failureStage)).setter(FailureDetails.setter(Builder::failureStage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureStage").build()}).build();
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailureDetails.getter(FailureDetails::failureType)).setter(FailureDetails.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()}).build();
    private static final SdkField<Map<String, List<String>>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(FailureDetails.getter(FailureDetails::details)).setter(FailureDetails.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_STAGE_FIELD, FAILURE_TYPE_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failureStage;
    private final String failureType;
    private final Map<String, List<String>> details;

    private FailureDetails(BuilderImpl builder) {
        this.failureStage = builder.failureStage;
        this.failureType = builder.failureType;
        this.details = builder.details;
    }

    public String failureStage() {
        return this.failureStage;
    }

    public String failureType() {
        return this.failureType;
    }

    public Map<String, List<String>> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureType());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        return Objects.equals(this.failureStage(), other.failureStage()) && Objects.equals(this.failureType(), other.failureType()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"FailureDetails").add("FailureStage", (Object)this.failureStage()).add("FailureType", (Object)this.failureType()).add("Details", this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureStage": {
                return Optional.ofNullable(clazz.cast(this.failureStage()));
            }
            case "FailureType": {
                return Optional.ofNullable(clazz.cast(this.failureType()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureDetails, T> g) {
        return obj -> g.apply((FailureDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureStage;
        private String failureType;
        private Map<String, List<String>> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.failureStage(model.failureStage);
            this.failureType(model.failureType);
            this.details(model.details);
        }

        public final String getFailureStage() {
            return this.failureStage;
        }

        @Override
        public final Builder failureStage(String failureStage) {
            this.failureStage = failureStage;
            return this;
        }

        public final void setFailureStage(String failureStage) {
            this.failureStage = failureStage;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final Map<String, ? extends Collection<String>> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
        }

        public FailureDetails build() {
            return new FailureDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailureDetails> {
        public Builder failureStage(String var1);

        public Builder failureType(String var1);

        public Builder details(Map<String, ? extends Collection<String>> var1);
    }
}

