/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentityListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMaintenanceWindowExecutionTaskInvocationsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
    private static final SdkField<List<MaintenanceWindowExecutionTaskInvocationIdentity>> WINDOW_EXECUTION_TASK_INVOCATION_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse.getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse::windowExecutionTaskInvocationIdentities)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse.setter(Builder::windowExecutionTaskInvocationIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionTaskInvocationIdentities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowExecutionTaskInvocationIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse.getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse::nextToken)).setter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_TASK_INVOCATION_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskInvocationIdentities = builder.windowExecutionTaskInvocationIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities() {
        return this.windowExecutionTaskInvocationIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionTaskInvocationIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsResponse other = (DescribeMaintenanceWindowExecutionTaskInvocationsResponse)((Object)obj);
        return Objects.equals(this.windowExecutionTaskInvocationIdentities(), other.windowExecutionTaskInvocationIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowExecutionTaskInvocationsResponse").add("WindowExecutionTaskInvocationIdentities", this.windowExecutionTaskInvocationIdentities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionTaskInvocationIdentities": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionTaskInvocationIdentities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionTaskInvocationsResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionTaskInvocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsResponse model) {
            super(model);
            this.windowExecutionTaskInvocationIdentities(model.windowExecutionTaskInvocationIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> getWindowExecutionTaskInvocationIdentities() {
            return this.windowExecutionTaskInvocationIdentities != null ? (Collection)this.windowExecutionTaskInvocationIdentities.stream().map(MaintenanceWindowExecutionTaskInvocationIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowExecutionTaskInvocationIdentities(Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier.copy(windowExecutionTaskInvocationIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(MaintenanceWindowExecutionTaskInvocationIdentity ... windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities(Arrays.asList(windowExecutionTaskInvocationIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> ... windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities(Stream.of(windowExecutionTaskInvocationIdentities).map(c -> (MaintenanceWindowExecutionTaskInvocationIdentity)((MaintenanceWindowExecutionTaskInvocationIdentity.Builder)MaintenanceWindowExecutionTaskInvocationIdentity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWindowExecutionTaskInvocationIdentities(Collection<MaintenanceWindowExecutionTaskInvocationIdentity.BuilderImpl> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier.copyFromBuilder(windowExecutionTaskInvocationIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsResponse build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
        public Builder windowExecutionTaskInvocationIdentities(Collection<MaintenanceWindowExecutionTaskInvocationIdentity> var1);

        public Builder windowExecutionTaskInvocationIdentities(MaintenanceWindowExecutionTaskInvocationIdentity ... var1);

        public Builder windowExecutionTaskInvocationIdentities(Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

