/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;

public class DescribeActivationsPublisher
implements SdkPublisher<DescribeActivationsResponse> {
    private final SsmAsyncClient client;
    private final DescribeActivationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeActivationsPublisher(SsmAsyncClient client, DescribeActivationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeActivationsPublisher(SsmAsyncClient client, DescribeActivationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeActivationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeActivationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Activation> activationList() {
        Function<DescribeActivationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.activationList() != null) {
                return response.activationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeActivationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeActivationsPublisher resume(DescribeActivationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeActivationsPublisher(this.client, (DescribeActivationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeActivationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeActivationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeActivationsResponseFetcher
    implements AsyncPageFetcher<DescribeActivationsResponse> {
        private DescribeActivationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeActivationsResponse> nextPage(DescribeActivationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivationsPublisher.this.client.describeActivations(DescribeActivationsPublisher.this.firstRequest);
            }
            return DescribeActivationsPublisher.this.client.describeActivations((DescribeActivationsRequest)((Object)DescribeActivationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

