/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.OutputSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationExecutionTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationExecutionTarget> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::associationId)).setter(AssociationExecutionTarget.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::associationVersion)).setter(AssociationExecutionTarget.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::executionId)).setter(AssociationExecutionTarget.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::resourceId)).setter(AssociationExecutionTarget.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::resourceType)).setter(AssociationExecutionTarget.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::status)).setter(AssociationExecutionTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::detailedStatus)).setter(AssociationExecutionTarget.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::lastExecutionDate)).setter(AssociationExecutionTarget.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final SdkField<OutputSource> OUTPUT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AssociationExecutionTarget.getter(AssociationExecutionTarget::outputSource)).setter(AssociationExecutionTarget.setter(Builder::outputSource)).constructor(OutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_VERSION_FIELD, EXECUTION_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, STATUS_FIELD, DETAILED_STATUS_FIELD, LAST_EXECUTION_DATE_FIELD, OUTPUT_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationVersion;
    private final String executionId;
    private final String resourceId;
    private final String resourceType;
    private final String status;
    private final String detailedStatus;
    private final Instant lastExecutionDate;
    private final OutputSource outputSource;

    private AssociationExecutionTarget(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.executionId = builder.executionId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.outputSource = builder.outputSource;
    }

    public String associationId() {
        return this.associationId;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public String executionId() {
        return this.executionId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public OutputSource outputSource() {
        return this.outputSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationExecutionTarget)) {
            return false;
        }
        AssociationExecutionTarget other = (AssociationExecutionTarget)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && Objects.equals(this.outputSource(), other.outputSource());
    }

    public String toString() {
        return ToString.builder((String)"AssociationExecutionTarget").add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("ExecutionId", (Object)this.executionId()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("OutputSource", (Object)this.outputSource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
            case "OutputSource": {
                return Optional.ofNullable(clazz.cast(this.outputSource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationExecutionTarget, T> g) {
        return obj -> g.apply((AssociationExecutionTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationVersion;
        private String executionId;
        private String resourceId;
        private String resourceType;
        private String status;
        private String detailedStatus;
        private Instant lastExecutionDate;
        private OutputSource outputSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationExecutionTarget model) {
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.executionId(model.executionId);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.lastExecutionDate(model.lastExecutionDate);
            this.outputSource(model.outputSource);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final OutputSource.Builder getOutputSource() {
            return this.outputSource != null ? this.outputSource.toBuilder() : null;
        }

        @Override
        public final Builder outputSource(OutputSource outputSource) {
            this.outputSource = outputSource;
            return this;
        }

        public final void setOutputSource(OutputSource.BuilderImpl outputSource) {
            this.outputSource = outputSource != null ? outputSource.build() : null;
        }

        public AssociationExecutionTarget build() {
            return new AssociationExecutionTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationExecutionTarget> {
        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder executionId(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder outputSource(OutputSource var1);

        default public Builder outputSource(Consumer<OutputSource.Builder> outputSource) {
            return this.outputSource((OutputSource)((OutputSource.Builder)OutputSource.builder().applyMutation(outputSource)).build());
        }
    }
}

