/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.LastResourceDataSyncStatus;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataSyncItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDataSyncItem> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::syncName)).setter(ResourceDataSyncItem.setter(Builder::syncName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()}).build();
    private static final SdkField<ResourceDataSyncS3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::s3Destination)).setter(ResourceDataSyncItem.setter(Builder::s3Destination)).constructor(ResourceDataSyncS3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()}).build();
    private static final SdkField<Instant> LAST_SYNC_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::lastSyncTime)).setter(ResourceDataSyncItem.setter(Builder::lastSyncTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncTime").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_SYNC_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::lastSuccessfulSyncTime)).setter(ResourceDataSyncItem.setter(Builder::lastSuccessfulSyncTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulSyncTime").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::lastStatusAsString)).setter(ResourceDataSyncItem.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatus").build()}).build();
    private static final SdkField<Instant> SYNC_CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::syncCreatedTime)).setter(ResourceDataSyncItem.setter(Builder::syncCreatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCreatedTime").build()}).build();
    private static final SdkField<String> LAST_SYNC_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceDataSyncItem.getter(ResourceDataSyncItem::lastSyncStatusMessage)).setter(ResourceDataSyncItem.setter(Builder::lastSyncStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD, S3_DESTINATION_FIELD, LAST_SYNC_TIME_FIELD, LAST_SUCCESSFUL_SYNC_TIME_FIELD, LAST_STATUS_FIELD, SYNC_CREATED_TIME_FIELD, LAST_SYNC_STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String syncName;
    private final ResourceDataSyncS3Destination s3Destination;
    private final Instant lastSyncTime;
    private final Instant lastSuccessfulSyncTime;
    private final String lastStatus;
    private final Instant syncCreatedTime;
    private final String lastSyncStatusMessage;

    private ResourceDataSyncItem(BuilderImpl builder) {
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
        this.lastSyncTime = builder.lastSyncTime;
        this.lastSuccessfulSyncTime = builder.lastSuccessfulSyncTime;
        this.lastStatus = builder.lastStatus;
        this.syncCreatedTime = builder.syncCreatedTime;
        this.lastSyncStatusMessage = builder.lastSyncStatusMessage;
    }

    public String syncName() {
        return this.syncName;
    }

    public ResourceDataSyncS3Destination s3Destination() {
        return this.s3Destination;
    }

    public Instant lastSyncTime() {
        return this.lastSyncTime;
    }

    public Instant lastSuccessfulSyncTime() {
        return this.lastSuccessfulSyncTime;
    }

    public LastResourceDataSyncStatus lastStatus() {
        return LastResourceDataSyncStatus.fromValue(this.lastStatus);
    }

    public String lastStatusAsString() {
        return this.lastStatus;
    }

    public Instant syncCreatedTime() {
        return this.syncCreatedTime;
    }

    public String lastSyncStatusMessage() {
        return this.lastSyncStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulSyncTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncCreatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncStatusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncItem)) {
            return false;
        }
        ResourceDataSyncItem other = (ResourceDataSyncItem)obj;
        return Objects.equals(this.syncName(), other.syncName()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.lastSyncTime(), other.lastSyncTime()) && Objects.equals(this.lastSuccessfulSyncTime(), other.lastSuccessfulSyncTime()) && Objects.equals(this.lastStatusAsString(), other.lastStatusAsString()) && Objects.equals(this.syncCreatedTime(), other.syncCreatedTime()) && Objects.equals(this.lastSyncStatusMessage(), other.lastSyncStatusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDataSyncItem").add("SyncName", (Object)this.syncName()).add("S3Destination", (Object)this.s3Destination()).add("LastSyncTime", (Object)this.lastSyncTime()).add("LastSuccessfulSyncTime", (Object)this.lastSuccessfulSyncTime()).add("LastStatus", (Object)this.lastStatusAsString()).add("SyncCreatedTime", (Object)this.syncCreatedTime()).add("LastSyncStatusMessage", (Object)this.lastSyncStatusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.ofNullable(clazz.cast(this.syncName()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "LastSyncTime": {
                return Optional.ofNullable(clazz.cast(this.lastSyncTime()));
            }
            case "LastSuccessfulSyncTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulSyncTime()));
            }
            case "LastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
            case "SyncCreatedTime": {
                return Optional.ofNullable(clazz.cast(this.syncCreatedTime()));
            }
            case "LastSyncStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lastSyncStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncItem, T> g) {
        return obj -> g.apply((ResourceDataSyncItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String syncName;
        private ResourceDataSyncS3Destination s3Destination;
        private Instant lastSyncTime;
        private Instant lastSuccessfulSyncTime;
        private String lastStatus;
        private Instant syncCreatedTime;
        private String lastSyncStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncItem model) {
            this.syncName(model.syncName);
            this.s3Destination(model.s3Destination);
            this.lastSyncTime(model.lastSyncTime);
            this.lastSuccessfulSyncTime(model.lastSuccessfulSyncTime);
            this.lastStatus(model.lastStatus);
            this.syncCreatedTime(model.syncCreatedTime);
            this.lastSyncStatusMessage(model.lastSyncStatusMessage);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        public final Instant getLastSyncTime() {
            return this.lastSyncTime;
        }

        @Override
        public final Builder lastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
            return this;
        }

        public final void setLastSyncTime(Instant lastSyncTime) {
            this.lastSyncTime = lastSyncTime;
        }

        public final Instant getLastSuccessfulSyncTime() {
            return this.lastSuccessfulSyncTime;
        }

        @Override
        public final Builder lastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
            return this;
        }

        public final void setLastSuccessfulSyncTime(Instant lastSuccessfulSyncTime) {
            this.lastSuccessfulSyncTime = lastSuccessfulSyncTime;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(LastResourceDataSyncStatus lastStatus) {
            this.lastStatus(lastStatus.toString());
            return this;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        public final Instant getSyncCreatedTime() {
            return this.syncCreatedTime;
        }

        @Override
        public final Builder syncCreatedTime(Instant syncCreatedTime) {
            this.syncCreatedTime = syncCreatedTime;
            return this;
        }

        public final void setSyncCreatedTime(Instant syncCreatedTime) {
            this.syncCreatedTime = syncCreatedTime;
        }

        public final String getLastSyncStatusMessage() {
            return this.lastSyncStatusMessage;
        }

        @Override
        public final Builder lastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
            return this;
        }

        public final void setLastSyncStatusMessage(String lastSyncStatusMessage) {
            this.lastSyncStatusMessage = lastSyncStatusMessage;
        }

        public ResourceDataSyncItem build() {
            return new ResourceDataSyncItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDataSyncItem> {
        public Builder syncName(String var1);

        public Builder s3Destination(ResourceDataSyncS3Destination var1);

        default public Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return this.s3Destination((ResourceDataSyncS3Destination)((ResourceDataSyncS3Destination.Builder)ResourceDataSyncS3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder lastSyncTime(Instant var1);

        public Builder lastSuccessfulSyncTime(Instant var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(LastResourceDataSyncStatus var1);

        public Builder syncCreatedTime(Instant var1);

        public Builder lastSyncStatusMessage(String var1);
    }
}

