/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ResultAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResultAttributeMarshaller {
    private static final MarshallingInfo<String> TYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TypeName").isBinary(false).build();
    private static final ResultAttributeMarshaller INSTANCE = new ResultAttributeMarshaller();

    private ResultAttributeMarshaller() {
    }

    public static ResultAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultAttribute resultAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resultAttribute, (String)"resultAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resultAttribute.typeName(), TYPENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

