/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceComplianceSummaryItemMarshaller {
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> OVERALLSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OverallSeverity").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionSummary").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMPLIANTSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompliantSummary").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NONCOMPLIANTSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonCompliantSummary").isBinary(false).build();
    private static final ResourceComplianceSummaryItemMarshaller INSTANCE = new ResourceComplianceSummaryItemMarshaller();

    private ResourceComplianceSummaryItemMarshaller() {
    }

    public static ResourceComplianceSummaryItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceComplianceSummaryItem resourceComplianceSummaryItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceComplianceSummaryItem, (String)"resourceComplianceSummaryItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.overallSeverityString(), OVERALLSEVERITY_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.compliantSummary(), COMPLIANTSUMMARY_BINDING);
            protocolMarshaller.marshall((Object)resourceComplianceSummaryItem.nonCompliantSummary(), NONCOMPLIANTSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

