/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentDefaultVersionDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DocumentDefaultVersionDescriptionMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").isBinary(false).build();
    private static final DocumentDefaultVersionDescriptionMarshaller INSTANCE = new DocumentDefaultVersionDescriptionMarshaller();

    private DocumentDefaultVersionDescriptionMarshaller() {
    }

    public static DocumentDefaultVersionDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentDefaultVersionDescription documentDefaultVersionDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)documentDefaultVersionDescription, (String)"documentDefaultVersionDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)documentDefaultVersionDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentDefaultVersionDescription.defaultVersion(), DEFAULTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

