/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateResourceDataSyncRequestModelMarshaller {
    private static final MarshallingInfo<String> SYNCNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Destination").isBinary(false).build();
    private static final CreateResourceDataSyncRequestModelMarshaller INSTANCE = new CreateResourceDataSyncRequestModelMarshaller();

    private CreateResourceDataSyncRequestModelMarshaller() {
    }

    public static CreateResourceDataSyncRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateResourceDataSyncRequest createResourceDataSyncRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createResourceDataSyncRequest), (String)"createResourceDataSyncRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createResourceDataSyncRequest.syncName(), SYNCNAME_BINDING);
            protocolMarshaller.marshall((Object)createResourceDataSyncRequest.s3Destination(), S3DESTINATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

