/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CommandMarshaller {
    private static final MarshallingInfo<String> COMMANDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommandId").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRESAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpiresAfter").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<Instant> REQUESTEDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3Region").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3BucketName").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTS3KEYPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputS3KeyPrefix").isBinary(false).build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").isBinary(false).build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").isBinary(false).build();
    private static final MarshallingInfo<Integer> TARGETCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> COMPLETEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedCount").isBinary(false).build();
    private static final MarshallingInfo<Integer> ERRORCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCount").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationConfig").isBinary(false).build();
    private static final CommandMarshaller INSTANCE = new CommandMarshaller();

    private CommandMarshaller() {
    }

    public static CommandMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Command command, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)command, (String)"command");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)command.commandId(), COMMANDID_BINDING);
            protocolMarshaller.marshall((Object)command.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)command.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall((Object)command.expiresAfter(), EXPIRESAFTER_BINDING);
            protocolMarshaller.marshall(command.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(command.instanceIds(), INSTANCEIDS_BINDING);
            protocolMarshaller.marshall(command.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)command.requestedDateTime(), REQUESTEDDATETIME_BINDING);
            protocolMarshaller.marshall((Object)command.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)command.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3Region(), OUTPUTS3REGION_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3BucketName(), OUTPUTS3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)command.outputS3KeyPrefix(), OUTPUTS3KEYPREFIX_BINDING);
            protocolMarshaller.marshall((Object)command.maxConcurrency(), MAXCONCURRENCY_BINDING);
            protocolMarshaller.marshall((Object)command.maxErrors(), MAXERRORS_BINDING);
            protocolMarshaller.marshall((Object)command.targetCount(), TARGETCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.completedCount(), COMPLETEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.errorCount(), ERRORCOUNT_BINDING);
            protocolMarshaller.marshall((Object)command.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)command.notificationConfig(), NOTIFICATIONCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

