/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ssm.SSMAsyncClient;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;

public class ListCommandsPublisher
implements SdkPublisher<ListCommandsResponse> {
    private final SSMAsyncClient client;
    private final ListCommandsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommandsPublisher(SSMAsyncClient client, ListCommandsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommandsPublisher(SSMAsyncClient client, ListCommandsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommandsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Command> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commands() != null) {
                return response.commands().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListCommandsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListCommandsPublisher resume(ListCommandsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCommandsPublisher(this.client, (ListCommandsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCommandsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListCommandsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListCommandsResponseFetcher
    implements AsyncPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListCommandsResponse> nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsPublisher.this.client.listCommands(ListCommandsPublisher.this.firstRequest);
            }
            return ListCommandsPublisher.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

