/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;

public class ListAssociationsIterable
implements SdkIterable<ListAssociationsResponse> {
    private final SSMClient client;
    private final ListAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociationsIterable(SSMClient client, ListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public Iterator<ListAssociationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Association> associations() {
        Function<ListAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListAssociationsIterable resume(ListAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAssociationsIterable(this.client, (ListAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAssociationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAssociationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAssociationsResponseFetcher
    implements SyncPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAssociationsResponse nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsIterable.this.client.listAssociations(ListAssociationsIterable.this.firstRequest);
            }
            return ListAssociationsIterable.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

