/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Format;
import software.amazon.awssdk.services.ssm.transform.ResourceDataSyncS3DestinationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceDataSyncS3Destination
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceDataSyncS3Destination> {
    private final String bucketName;
    private final String prefix;
    private final String syncFormat;
    private final String region;
    private final String awskmsKeyARN;

    private ResourceDataSyncS3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.prefix = builder.prefix;
        this.syncFormat = builder.syncFormat;
        this.region = builder.region;
        this.awskmsKeyARN = builder.awskmsKeyARN;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String prefix() {
        return this.prefix;
    }

    public ResourceDataSyncS3Format syncFormat() {
        return ResourceDataSyncS3Format.fromValue(this.syncFormat);
    }

    public String syncFormatString() {
        return this.syncFormat;
    }

    public String region() {
        return this.region;
    }

    public String awskmsKeyARN() {
        return this.awskmsKeyARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.awskmsKeyARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncS3Destination)) {
            return false;
        }
        ResourceDataSyncS3Destination other = (ResourceDataSyncS3Destination)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.syncFormatString(), other.syncFormatString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.awskmsKeyARN(), other.awskmsKeyARN());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDataSyncS3Destination").add("BucketName", (Object)this.bucketName()).add("Prefix", (Object)this.prefix()).add("SyncFormat", (Object)this.syncFormatString()).add("Region", (Object)this.region()).add("AWSKMSKeyARN", (Object)this.awskmsKeyARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.of(clazz.cast(this.bucketName()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "SyncFormat": {
                return Optional.of(clazz.cast(this.syncFormatString()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.region()));
            }
            case "AWSKMSKeyARN": {
                return Optional.of(clazz.cast(this.awskmsKeyARN()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceDataSyncS3DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String prefix;
        private String syncFormat;
        private String region;
        private String awskmsKeyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncS3Destination model) {
            this.bucketName(model.bucketName);
            this.prefix(model.prefix);
            this.syncFormat(model.syncFormat);
            this.region(model.region);
            this.awskmsKeyARN(model.awskmsKeyARN);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getSyncFormat() {
            return this.syncFormat;
        }

        @Override
        public final Builder syncFormat(String syncFormat) {
            this.syncFormat = syncFormat;
            return this;
        }

        @Override
        public final Builder syncFormat(ResourceDataSyncS3Format syncFormat) {
            this.syncFormat(syncFormat.toString());
            return this;
        }

        public final void setSyncFormat(String syncFormat) {
            this.syncFormat = syncFormat;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAWSKMSKeyARN() {
            return this.awskmsKeyARN;
        }

        @Override
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final void setAWSKMSKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        public ResourceDataSyncS3Destination build() {
            return new ResourceDataSyncS3Destination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceDataSyncS3Destination> {
        public Builder bucketName(String var1);

        public Builder prefix(String var1);

        public Builder syncFormat(String var1);

        public Builder syncFormat(ResourceDataSyncS3Format var1);

        public Builder region(String var1);

        public Builder awskmsKeyARN(String var1);
    }
}

