/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterValueListCopier;
import software.amazon.awssdk.services.ssm.transform.ParameterStringFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterStringFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterStringFilter> {
    private final String key;
    private final String option;
    private final List<String> values;

    private ParameterStringFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.option = builder.option;
        this.values = builder.values;
    }

    public String key() {
        return this.key;
    }

    public String option() {
        return this.option;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.option());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterStringFilter)) {
            return false;
        }
        ParameterStringFilter other = (ParameterStringFilter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.option(), other.option()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        return ToString.builder((String)"ParameterStringFilter").add("Key", (Object)this.key()).add("Option", (Object)this.option()).add("Values", this.values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Option": {
                return Optional.of(clazz.cast(this.option()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterStringFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String option;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterStringFilter model) {
            this.key(model.key);
            this.option(model.option);
            this.values(model.values);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getOption() {
            return this.option;
        }

        @Override
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ParameterStringFilterValueListCopier.copy(values);
        }

        public ParameterStringFilter build() {
            return new ParameterStringFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterStringFilter> {
        public Builder key(String var1);

        public Builder option(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

