/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem;
import software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourceComplianceSummariesResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
    private final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;
    private final String nextToken;

    private ListResourceComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceComplianceSummaryItems = builder.resourceComplianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    public List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        return this.resourceComplianceSummaryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceComplianceSummaryItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceComplianceSummariesResponse)) {
            return false;
        }
        ListResourceComplianceSummariesResponse other = (ListResourceComplianceSummariesResponse)((Object)obj);
        return Objects.equals(this.resourceComplianceSummaryItems(), other.resourceComplianceSummaryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceComplianceSummariesResponse").add("ResourceComplianceSummaryItems", this.resourceComplianceSummaryItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceComplianceSummaryItems": {
                return Optional.of(clazz.cast(this.resourceComplianceSummaryItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceComplianceSummariesResponse model) {
            this.resourceComplianceSummaryItems(model.resourceComplianceSummaryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceComplianceSummaryItem.Builder> getResourceComplianceSummaryItems() {
            return this.resourceComplianceSummaryItems != null ? (Collection)this.resourceComplianceSummaryItems.stream().map(ResourceComplianceSummaryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copy(resourceComplianceSummaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem ... resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems(Arrays.asList(resourceComplianceSummaryItems));
            return this;
        }

        public final void setResourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem.BuilderImpl> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copyFromBuilder(resourceComplianceSummaryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceComplianceSummariesResponse build() {
            return new ListResourceComplianceSummariesResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
        public Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> var1);

        public Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem ... var1);

        public Builder nextToken(String var1);
    }
}

