/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDefaultPatchBaselineResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetDefaultPatchBaselineResponse> {
    private final String baselineId;
    private final String operatingSystem;

    private GetDefaultPatchBaselineResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.operatingSystem = builder.operatingSystem;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemString() {
        return this.operatingSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDefaultPatchBaselineResponse)) {
            return false;
        }
        GetDefaultPatchBaselineResponse other = (GetDefaultPatchBaselineResponse)((Object)obj);
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.operatingSystemString(), other.operatingSystemString());
    }

    public String toString() {
        return ToString.builder((String)"GetDefaultPatchBaselineResponse").add("BaselineId", (Object)this.baselineId()).add("OperatingSystem", (Object)this.operatingSystemString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.of(clazz.cast(this.baselineId()));
            }
            case "OperatingSystem": {
                return Optional.of(clazz.cast(this.operatingSystemString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String baselineId;
        private String operatingSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDefaultPatchBaselineResponse model) {
            this.baselineId(model.baselineId);
            this.operatingSystem(model.operatingSystem);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public GetDefaultPatchBaselineResponse build() {
            return new GetDefaultPatchBaselineResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetDefaultPatchBaselineResponse> {
        public Builder baselineId(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);
    }
}

