/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.AssociationVersionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociationVersionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, AssociationVersionInfo> {
    private final String associationId;
    private final String associationVersion;
    private final Instant createdDate;
    private final String name;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String associationName;

    private AssociationVersionInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.createdDate = builder.createdDate;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.associationName = builder.associationName;
    }

    public String associationId() {
        return this.associationId;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public String associationName() {
        return this.associationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationVersionInfo)) {
            return false;
        }
        AssociationVersionInfo other = (AssociationVersionInfo)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.associationName(), other.associationName());
    }

    public String toString() {
        return ToString.builder((String)"AssociationVersionInfo").add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("CreatedDate", (Object)this.createdDate()).add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", this.parameters()).add("Targets", this.targets()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("AssociationName", (Object)this.associationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.of(clazz.cast(this.associationVersion()));
            }
            case "CreatedDate": {
                return Optional.of(clazz.cast(this.createdDate()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.of(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.of(clazz.cast(this.outputLocation()));
            }
            case "AssociationName": {
                return Optional.of(clazz.cast(this.associationName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationVersionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationVersion;
        private Instant createdDate;
        private String name;
        private String documentVersion;
        private Map<String, List<String>> parameters;
        private List<Target> targets;
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationVersionInfo model) {
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.createdDate(model.createdDate);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.associationName(model.associationName);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public AssociationVersionInfo build() {
            return new AssociationVersionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociationVersionInfo> {
        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder createdDate(Instant var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().apply(outputLocation)).build());
        }

        public Builder associationName(String var1);
    }
}

