/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;

@SdkInternalApi
public class PutComplianceItemsRequestModelMarshaller {
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceId").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<String> COMPLIANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceType").build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionSummary").build();
    private static final MarshallingInfo<List> ITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Items").build();
    private static final MarshallingInfo<String> ITEMCONTENTHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemContentHash").build();
    private static final PutComplianceItemsRequestModelMarshaller INSTANCE = new PutComplianceItemsRequestModelMarshaller();

    public static PutComplianceItemsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutComplianceItemsRequest putComplianceItemsRequest, ProtocolMarshaller protocolMarshaller) {
        if (putComplianceItemsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.resourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.complianceType(), COMPLIANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.executionSummary(), EXECUTIONSUMMARY_BINDING);
            protocolMarshaller.marshall(putComplianceItemsRequest.items(), ITEMS_BINDING);
            protocolMarshaller.marshall((Object)putComplianceItemsRequest.itemContentHash(), ITEMCONTENTHASH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

