/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.ParameterMetadata;

public class ParameterMetadataUnmarshaller
implements Unmarshaller<ParameterMetadata, JsonUnmarshallerContext> {
    private static final ParameterMetadataUnmarshaller INSTANCE = new ParameterMetadataUnmarshaller();

    public ParameterMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        ParameterMetadata.Builder parameterMetadataBuilder = ParameterMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.keyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.lastModifiedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedUser", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.lastModifiedUser((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AllowedPattern", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.allowedPattern((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    parameterMetadataBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ParameterMetadata)parameterMetadataBuilder.build();
    }

    public static ParameterMetadataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

