/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;

public final class ListCommandInvocationsPaginator
implements SdkIterable<ListCommandInvocationsResponse> {
    private final SSMClient client;
    private final ListCommandInvocationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCommandInvocationsPaginator(SSMClient client, ListCommandInvocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandInvocationsResponseFetcher();
    }

    public Iterator<ListCommandInvocationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CommandInvocation> commandInvocations() {
        Function<ListCommandInvocationsResponse, Iterator> getIterator = response -> response != null ? response.commandInvocations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListCommandInvocationsResponseFetcher
    implements NextPageFetcher<ListCommandInvocationsResponse> {
        private ListCommandInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandInvocationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCommandInvocationsResponse nextPage(ListCommandInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandInvocationsPaginator.this.client.listCommandInvocations(ListCommandInvocationsPaginator.this.firstRequest);
            }
            return ListCommandInvocationsPaginator.this.client.listCommandInvocations((ListCommandInvocationsRequest)((Object)ListCommandInvocationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

