/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;

public final class GetParameterHistoryPaginator
implements SdkIterable<GetParameterHistoryResponse> {
    private final SSMClient client;
    private final GetParameterHistoryRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetParameterHistoryPaginator(SSMClient client, GetParameterHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParameterHistoryResponseFetcher();
    }

    public Iterator<GetParameterHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetParameterHistoryResponseFetcher
    implements NextPageFetcher<GetParameterHistoryResponse> {
        private GetParameterHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetParameterHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetParameterHistoryResponse nextPage(GetParameterHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetParameterHistoryPaginator.this.client.getParameterHistory(GetParameterHistoryPaginator.this.firstRequest);
            }
            return GetParameterHistoryPaginator.this.client.getParameterHistory((GetParameterHistoryRequest)((Object)GetParameterHistoryPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

