/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.ssm.transform.ParameterMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterMetadata> {
    private final String name;
    private final String type;
    private final String keyId;
    private final Instant lastModifiedDate;
    private final String lastModifiedUser;
    private final String description;
    private final String allowedPattern;
    private final Long version;

    private ParameterMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.keyId = builder.keyId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.description = builder.description;
        this.allowedPattern = builder.allowedPattern;
        this.version = builder.version;
    }

    public String name() {
        return this.name;
    }

    public ParameterType type() {
        return ParameterType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String keyId() {
        return this.keyId;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String lastModifiedUser() {
        return this.lastModifiedUser;
    }

    public String description() {
        return this.description;
    }

    public String allowedPattern() {
        return this.allowedPattern;
    }

    public Long version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterMetadata)) {
            return false;
        }
        ParameterMetadata other = (ParameterMetadata)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedUser(), other.lastModifiedUser()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.allowedPattern(), other.allowedPattern()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"ParameterMetadata").add("Name", (Object)this.name()).add("Type", (Object)this.typeString()).add("KeyId", (Object)this.keyId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedUser", (Object)this.lastModifiedUser()).add("Description", (Object)this.description()).add("AllowedPattern", (Object)this.allowedPattern()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "KeyId": {
                return Optional.of(clazz.cast(this.keyId()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedUser": {
                return Optional.of(clazz.cast(this.lastModifiedUser()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "AllowedPattern": {
                return Optional.of(clazz.cast(this.allowedPattern()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String keyId;
        private Instant lastModifiedDate;
        private String lastModifiedUser;
        private String description;
        private String allowedPattern;
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterMetadata model) {
            this.name(model.name);
            this.type(model.type);
            this.keyId(model.keyId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedUser(model.lastModifiedUser);
            this.description(model.description);
            this.allowedPattern(model.allowedPattern);
            this.version(model.version);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAllowedPattern() {
            return this.allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public ParameterMetadata build() {
            return new ParameterMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterMetadata> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ParameterType var1);

        public Builder keyId(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedUser(String var1);

        public Builder description(String var1);

        public Builder allowedPattern(String var1);

        public Builder version(Long var1);
    }
}

