/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InventoryItemEntryListCopier;
import software.amazon.awssdk.services.ssm.transform.InventoryResultItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryResultItem
implements StructuredPojo,
ToCopyableBuilder<Builder, InventoryResultItem> {
    private final String typeName;
    private final String schemaVersion;
    private final String captureTime;
    private final String contentHash;
    private final List<Map<String, String>> content;

    private InventoryResultItem(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.contentHash = builder.contentHash;
        this.content = builder.content;
    }

    public String typeName() {
        return this.typeName;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String captureTime() {
        return this.captureTime;
    }

    public String contentHash() {
        return this.contentHash;
    }

    public List<Map<String, String>> content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultItem)) {
            return false;
        }
        InventoryResultItem other = (InventoryResultItem)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.captureTime(), other.captureTime()) && Objects.equals(this.contentHash(), other.contentHash()) && Objects.equals(this.content(), other.content());
    }

    public String toString() {
        return ToString.builder((String)"InventoryResultItem").add("TypeName", (Object)this.typeName()).add("SchemaVersion", (Object)this.schemaVersion()).add("CaptureTime", (Object)this.captureTime()).add("ContentHash", (Object)this.contentHash()).add("Content", this.content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.of(clazz.cast(this.typeName()));
            }
            case "SchemaVersion": {
                return Optional.of(clazz.cast(this.schemaVersion()));
            }
            case "CaptureTime": {
                return Optional.of(clazz.cast(this.captureTime()));
            }
            case "ContentHash": {
                return Optional.of(clazz.cast(this.contentHash()));
            }
            case "Content": {
                return Optional.of(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryResultItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String schemaVersion;
        private String captureTime;
        private String contentHash;
        private List<Map<String, String>> content;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultItem model) {
            this.typeName(model.typeName);
            this.schemaVersion(model.schemaVersion);
            this.captureTime(model.captureTime);
            this.contentHash(model.contentHash);
            this.content(model.content);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return this.captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final String getContentHash() {
            return this.contentHash;
        }

        @Override
        public final Builder contentHash(String contentHash) {
            this.contentHash = contentHash;
            return this;
        }

        public final void setContentHash(String contentHash) {
            this.contentHash = contentHash;
        }

        public final Collection<Map<String, String>> getContent() {
            return this.content;
        }

        @Override
        public final Builder content(Collection<Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Map<String, String> ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        public final void setContent(Collection<Map<String, String>> content) {
            this.content = InventoryItemEntryListCopier.copy(content);
        }

        public InventoryResultItem build() {
            return new InventoryResultItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryResultItem> {
        public Builder typeName(String var1);

        public Builder schemaVersion(String var1);

        public Builder captureTime(String var1);

        public Builder contentHash(String var1);

        public Builder content(Collection<Map<String, String>> var1);

        public Builder content(Map<String, String> ... var1);
    }
}

