/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionTaskRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskRequest> {
    private final String windowExecutionId;
    private final String taskId;

    private GetMaintenanceWindowExecutionTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowExecutionId = builder.windowExecutionId;
        this.taskId = builder.taskId;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskId() {
        return this.taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionTaskRequest)) {
            return false;
        }
        GetMaintenanceWindowExecutionTaskRequest other = (GetMaintenanceWindowExecutionTaskRequest)((Object)obj);
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskId(), other.taskId());
    }

    public String toString() {
        return ToString.builder((String)"GetMaintenanceWindowExecutionTaskRequest").add("WindowExecutionId", (Object)this.windowExecutionId()).add("TaskId", (Object)this.taskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskId": {
                return Optional.of(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionTaskRequest model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskId(model.taskId);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetMaintenanceWindowExecutionTaskRequest build() {
            return new GetMaintenanceWindowExecutionTaskRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetMaintenanceWindowExecutionTaskRequest> {
        public Builder windowExecutionId(String var1);

        public Builder taskId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

