/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;

public final class ListDocumentsPaginator
implements SdkIterable<ListDocumentsResponse> {
    private final SSMClient client;
    private final ListDocumentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDocumentsPaginator(SSMClient client, ListDocumentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDocumentsResponseFetcher();
    }

    public Iterator<ListDocumentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<DocumentIdentifier> documentIdentifiers() {
        Function<ListDocumentsResponse, Iterator> getIterator = response -> response != null ? response.documentIdentifiers().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDocumentsResponseFetcher
    implements NextPageFetcher<ListDocumentsResponse> {
        private ListDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDocumentsResponse nextPage(ListDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentsPaginator.this.client.listDocuments(ListDocumentsPaginator.this.firstRequest);
            }
            return ListDocumentsPaginator.this.client.listDocuments((ListDocumentsRequest)((Object)ListDocumentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

