/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;
import software.amazon.awssdk.services.ssm.transform.PatchGroupPatchBaselineMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchGroupPatchBaselineMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchGroupPatchBaselineMapping> {
    private final String patchGroup;
    private final PatchBaselineIdentity baselineIdentity;

    private PatchGroupPatchBaselineMapping(BuilderImpl builder) {
        this.patchGroup = builder.patchGroup;
        this.baselineIdentity = builder.baselineIdentity;
    }

    public String patchGroup() {
        return this.patchGroup;
    }

    public PatchBaselineIdentity baselineIdentity() {
        return this.baselineIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIdentity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchGroupPatchBaselineMapping)) {
            return false;
        }
        PatchGroupPatchBaselineMapping other = (PatchGroupPatchBaselineMapping)obj;
        return Objects.equals(this.patchGroup(), other.patchGroup()) && Objects.equals(this.baselineIdentity(), other.baselineIdentity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patchGroup() != null) {
            sb.append("PatchGroup: ").append(this.patchGroup()).append(",");
        }
        if (this.baselineIdentity() != null) {
            sb.append("BaselineIdentity: ").append(this.baselineIdentity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchGroup": {
                return Optional.of(clazz.cast(this.patchGroup()));
            }
            case "BaselineIdentity": {
                return Optional.of(clazz.cast(this.baselineIdentity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchGroupPatchBaselineMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String patchGroup;
        private PatchBaselineIdentity baselineIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchGroupPatchBaselineMapping model) {
            this.patchGroup(model.patchGroup);
            this.baselineIdentity(model.baselineIdentity);
        }

        public final String getPatchGroup() {
            return this.patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        public final PatchBaselineIdentity.Builder getBaselineIdentity() {
            return this.baselineIdentity != null ? this.baselineIdentity.toBuilder() : null;
        }

        @Override
        public final Builder baselineIdentity(PatchBaselineIdentity baselineIdentity) {
            this.baselineIdentity = baselineIdentity;
            return this;
        }

        public final void setBaselineIdentity(PatchBaselineIdentity.BuilderImpl baselineIdentity) {
            this.baselineIdentity = baselineIdentity != null ? baselineIdentity.build() : null;
        }

        public PatchGroupPatchBaselineMapping build() {
            return new PatchGroupPatchBaselineMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchGroupPatchBaselineMapping> {
        public Builder patchGroup(String var1);

        public Builder baselineIdentity(PatchBaselineIdentity var1);

        default public Builder baselineIdentity(Consumer<PatchBaselineIdentity.Builder> baselineIdentity) {
            return this.baselineIdentity((PatchBaselineIdentity)((PatchBaselineIdentity.Builder)PatchBaselineIdentity.builder().apply(baselineIdentity)).build());
        }
    }
}

