/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueListCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskParameterValueExpressionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowTaskParameterValueExpression
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
    private final List<String> values;

    private MaintenanceWindowTaskParameterValueExpression(BuilderImpl builder) {
        this.values = builder.values;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskParameterValueExpression)) {
            return false;
        }
        MaintenanceWindowTaskParameterValueExpression other = (MaintenanceWindowTaskParameterValueExpression)obj;
        return Objects.equals(this.values(), other.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskParameterValueExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskParameterValueExpression model) {
            this.values(model.values);
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
        }

        public MaintenanceWindowTaskParameterValueExpression build() {
            return new MaintenanceWindowTaskParameterValueExpression(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

