/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskType;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowExecutionTaskInvocationIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowExecutionTaskInvocationIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String invocationId;
    private final String executionId;
    private final String taskType;
    private final String parameters;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;
    private final String ownerInformation;
    private final String windowTargetId;

    private MaintenanceWindowExecutionTaskInvocationIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.invocationId = builder.invocationId;
        this.executionId = builder.executionId;
        this.taskType = builder.taskType;
        this.parameters = builder.parameters;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ownerInformation = builder.ownerInformation;
        this.windowTargetId = builder.windowTargetId;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public String executionId() {
        return this.executionId;
    }

    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(this.taskType);
    }

    public String taskTypeString() {
        return this.taskType;
    }

    public String parameters() {
        return this.parameters;
    }

    public MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTargetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskInvocationIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskInvocationIdentity other = (MaintenanceWindowExecutionTaskInvocationIdentity)obj;
        return Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.taskExecutionId(), other.taskExecutionId()) && Objects.equals(this.invocationId(), other.invocationId()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.taskTypeString(), other.taskTypeString()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.windowTargetId(), other.windowTargetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(this.taskExecutionId()).append(",");
        }
        if (this.invocationId() != null) {
            sb.append("InvocationId: ").append(this.invocationId()).append(",");
        }
        if (this.executionId() != null) {
            sb.append("ExecutionId: ").append(this.executionId()).append(",");
        }
        if (this.taskTypeString() != null) {
            sb.append("TaskType: ").append(this.taskTypeString()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.ownerInformation()).append(",");
        }
        if (this.windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.windowTargetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowExecutionId": {
                return Optional.of(clazz.cast(this.windowExecutionId()));
            }
            case "TaskExecutionId": {
                return Optional.of(clazz.cast(this.taskExecutionId()));
            }
            case "InvocationId": {
                return Optional.of(clazz.cast(this.invocationId()));
            }
            case "ExecutionId": {
                return Optional.of(clazz.cast(this.executionId()));
            }
            case "TaskType": {
                return Optional.of(clazz.cast(this.taskTypeString()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "OwnerInformation": {
                return Optional.of(clazz.cast(this.ownerInformation()));
            }
            case "WindowTargetId": {
                return Optional.of(clazz.cast(this.windowTargetId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowExecutionTaskInvocationIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String invocationId;
        private String executionId;
        private String taskType;
        private String parameters;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;
        private String ownerInformation;
        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskInvocationIdentity model) {
            this.windowExecutionId(model.windowExecutionId);
            this.taskExecutionId(model.taskExecutionId);
            this.invocationId(model.invocationId);
            this.executionId(model.executionId);
            this.taskType(model.taskType);
            this.parameters(model.parameters);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.ownerInformation(model.ownerInformation);
            this.windowTargetId(model.windowTargetId);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getTaskType() {
            return this.taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public MaintenanceWindowExecutionTaskInvocationIdentity build() {
            return new MaintenanceWindowExecutionTaskInvocationIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder invocationId(String var1);

        public Builder executionId(String var1);

        public Builder taskType(String var1);

        public Builder taskType(MaintenanceWindowTaskType var1);

        public Builder parameters(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ownerInformation(String var1);

        public Builder windowTargetId(String var1);
    }
}

