/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ssm.model.SSMRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCommandInvocationRequest
extends SSMRequest
implements ToCopyableBuilder<Builder, GetCommandInvocationRequest> {
    private final String commandId;
    private final String instanceId;
    private final String pluginName;

    private GetCommandInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.pluginName = builder.pluginName;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String pluginName() {
        return this.pluginName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationRequest)) {
            return false;
        }
        GetCommandInvocationRequest other = (GetCommandInvocationRequest)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.pluginName(), other.pluginName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.pluginName() != null) {
            sb.append("PluginName: ").append(this.pluginName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.of(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "PluginName": {
                return Optional.of(clazz.cast(this.pluginName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMRequest.BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String pluginName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationRequest model) {
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.pluginName(model.pluginName);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetCommandInvocationRequest build() {
            return new GetCommandInvocationRequest(this);
        }
    }

    public static interface Builder
    extends SSMRequest.Builder,
    CopyableBuilder<Builder, GetCommandInvocationRequest> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder pluginName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

