/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.services.ssm.model.PatchStatus;
import software.amazon.awssdk.services.ssm.transform.EffectivePatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EffectivePatch
implements StructuredPojo,
ToCopyableBuilder<Builder, EffectivePatch> {
    private final Patch patch;
    private final PatchStatus patchStatus;

    private EffectivePatch(BuilderImpl builder) {
        this.patch = builder.patch;
        this.patchStatus = builder.patchStatus;
    }

    public Patch patch() {
        return this.patch;
    }

    public PatchStatus patchStatus() {
        return this.patchStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.patch());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePatch)) {
            return false;
        }
        EffectivePatch other = (EffectivePatch)obj;
        return Objects.equals(this.patch(), other.patch()) && Objects.equals(this.patchStatus(), other.patchStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.patch() != null) {
            sb.append("Patch: ").append(this.patch()).append(",");
        }
        if (this.patchStatus() != null) {
            sb.append("PatchStatus: ").append(this.patchStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patch": {
                return Optional.of(clazz.cast(this.patch()));
            }
            case "PatchStatus": {
                return Optional.of(clazz.cast(this.patchStatus()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EffectivePatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Patch patch;
        private PatchStatus patchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePatch model) {
            this.patch(model.patch);
            this.patchStatus(model.patchStatus);
        }

        public final Patch.Builder getPatch() {
            return this.patch != null ? this.patch.toBuilder() : null;
        }

        @Override
        public final Builder patch(Patch patch) {
            this.patch = patch;
            return this;
        }

        public final void setPatch(Patch.BuilderImpl patch) {
            this.patch = patch != null ? patch.build() : null;
        }

        public final PatchStatus.Builder getPatchStatus() {
            return this.patchStatus != null ? this.patchStatus.toBuilder() : null;
        }

        @Override
        public final Builder patchStatus(PatchStatus patchStatus) {
            this.patchStatus = patchStatus;
            return this;
        }

        public final void setPatchStatus(PatchStatus.BuilderImpl patchStatus) {
            this.patchStatus = patchStatus != null ? patchStatus.build() : null;
        }

        public EffectivePatch build() {
            return new EffectivePatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EffectivePatch> {
        public Builder patch(Patch var1);

        default public Builder patch(Consumer<Patch.Builder> patch) {
            return this.patch((Patch)((Patch.Builder)Patch.builder().apply(patch)).build());
        }

        public Builder patchStatus(PatchStatus var1);

        default public Builder patchStatus(Consumer<PatchStatus.Builder> patchStatus) {
            return this.patchStatus((PatchStatus)((PatchStatus.Builder)PatchStatus.builder().apply(patchStatus)).build());
        }
    }
}

