/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.services.ssm.model.InstanceInformationListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceInformationResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeInstanceInformationResponse> {
    private final List<InstanceInformation> instanceInformationList;
    private final String nextToken;

    private DescribeInstanceInformationResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInformationList = builder.instanceInformationList;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceInformation> instanceInformationList() {
        return this.instanceInformationList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInformationList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationResponse)) {
            return false;
        }
        DescribeInstanceInformationResponse other = (DescribeInstanceInformationResponse)((Object)obj);
        return Objects.equals(this.instanceInformationList(), other.instanceInformationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceInformationList() != null) {
            sb.append("InstanceInformationList: ").append(this.instanceInformationList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceInformationList": {
                return Optional.of(clazz.cast(this.instanceInformationList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<InstanceInformation> instanceInformationList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationResponse model) {
            this.instanceInformationList(model.instanceInformationList);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceInformation.Builder> getInstanceInformationList() {
            return this.instanceInformationList != null ? (Collection)this.instanceInformationList.stream().map(InstanceInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(InstanceInformation ... instanceInformationList) {
            this.instanceInformationList(Arrays.asList(instanceInformationList));
            return this;
        }

        public final void setInstanceInformationList(Collection<InstanceInformation.BuilderImpl> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copyFromBuilder(instanceInformationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceInformationResponse build() {
            return new DescribeInstanceInformationResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeInstanceInformationResponse> {
        public Builder instanceInformationList(Collection<InstanceInformation> var1);

        public Builder instanceInformationList(InstanceInformation ... var1);

        public Builder nextToken(String var1);
    }
}

