/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CompliantSummary;
import software.amazon.awssdk.services.ssm.model.NonCompliantSummary;
import software.amazon.awssdk.services.ssm.transform.ComplianceSummaryItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComplianceSummaryItem
implements StructuredPojo,
ToCopyableBuilder<Builder, ComplianceSummaryItem> {
    private final String complianceType;
    private final CompliantSummary compliantSummary;
    private final NonCompliantSummary nonCompliantSummary;

    private ComplianceSummaryItem(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.compliantSummary = builder.compliantSummary;
        this.nonCompliantSummary = builder.nonCompliantSummary;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public CompliantSummary compliantSummary() {
        return this.compliantSummary;
    }

    public NonCompliantSummary nonCompliantSummary() {
        return this.nonCompliantSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonCompliantSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComplianceSummaryItem)) {
            return false;
        }
        ComplianceSummaryItem other = (ComplianceSummaryItem)obj;
        return Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.compliantSummary(), other.compliantSummary()) && Objects.equals(this.nonCompliantSummary(), other.nonCompliantSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.compliantSummary() != null) {
            sb.append("CompliantSummary: ").append(this.compliantSummary()).append(",");
        }
        if (this.nonCompliantSummary() != null) {
            sb.append("NonCompliantSummary: ").append(this.nonCompliantSummary()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.of(clazz.cast(this.complianceType()));
            }
            case "CompliantSummary": {
                return Optional.of(clazz.cast(this.compliantSummary()));
            }
            case "NonCompliantSummary": {
                return Optional.of(clazz.cast(this.nonCompliantSummary()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComplianceSummaryItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private CompliantSummary compliantSummary;
        private NonCompliantSummary nonCompliantSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ComplianceSummaryItem model) {
            this.complianceType(model.complianceType);
            this.compliantSummary(model.compliantSummary);
            this.nonCompliantSummary(model.nonCompliantSummary);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final CompliantSummary.Builder getCompliantSummary() {
            return this.compliantSummary != null ? this.compliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder compliantSummary(CompliantSummary compliantSummary) {
            this.compliantSummary = compliantSummary;
            return this;
        }

        public final void setCompliantSummary(CompliantSummary.BuilderImpl compliantSummary) {
            this.compliantSummary = compliantSummary != null ? compliantSummary.build() : null;
        }

        public final NonCompliantSummary.Builder getNonCompliantSummary() {
            return this.nonCompliantSummary != null ? this.nonCompliantSummary.toBuilder() : null;
        }

        @Override
        public final Builder nonCompliantSummary(NonCompliantSummary nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary;
            return this;
        }

        public final void setNonCompliantSummary(NonCompliantSummary.BuilderImpl nonCompliantSummary) {
            this.nonCompliantSummary = nonCompliantSummary != null ? nonCompliantSummary.build() : null;
        }

        public ComplianceSummaryItem build() {
            return new ComplianceSummaryItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComplianceSummaryItem> {
        public Builder complianceType(String var1);

        public Builder compliantSummary(CompliantSummary var1);

        default public Builder compliantSummary(Consumer<CompliantSummary.Builder> compliantSummary) {
            return this.compliantSummary((CompliantSummary)((CompliantSummary.Builder)CompliantSummary.builder().apply(compliantSummary)).build());
        }

        public Builder nonCompliantSummary(NonCompliantSummary var1);

        default public Builder nonCompliantSummary(Consumer<NonCompliantSummary.Builder> nonCompliantSummary) {
            return this.nonCompliantSummary((NonCompliantSummary)((NonCompliantSummary.Builder)NonCompliantSummary.builder().apply(nonCompliantSummary)).build());
        }
    }
}

