/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CommandStatus;
import software.amazon.awssdk.services.ssm.model.InstanceIdListCopier;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.CommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Command
implements StructuredPojo,
ToCopyableBuilder<Builder, Command> {
    private final String commandId;
    private final String documentName;
    private final String comment;
    private final Instant expiresAfter;
    private final Map<String, List<String>> parameters;
    private final List<String> instanceIds;
    private final List<Target> targets;
    private final Instant requestedDateTime;
    private final String status;
    private final String statusDetails;
    private final String outputS3Region;
    private final String outputS3BucketName;
    private final String outputS3KeyPrefix;
    private final String maxConcurrency;
    private final String maxErrors;
    private final Integer targetCount;
    private final Integer completedCount;
    private final Integer errorCount;
    private final String serviceRole;
    private final NotificationConfig notificationConfig;

    private Command(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.documentName = builder.documentName;
        this.comment = builder.comment;
        this.expiresAfter = builder.expiresAfter;
        this.parameters = builder.parameters;
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.requestedDateTime = builder.requestedDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetCount = builder.targetCount;
        this.completedCount = builder.completedCount;
        this.errorCount = builder.errorCount;
        this.serviceRole = builder.serviceRole;
        this.notificationConfig = builder.notificationConfig;
    }

    public String commandId() {
        return this.commandId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String comment() {
        return this.comment;
    }

    public Instant expiresAfter() {
        return this.expiresAfter;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Instant requestedDateTime() {
        return this.requestedDateTime;
    }

    public CommandStatus status() {
        return CommandStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String outputS3Region() {
        return this.outputS3Region;
    }

    public String outputS3BucketName() {
        return this.outputS3BucketName;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public Integer targetCount() {
        return this.targetCount;
    }

    public Integer completedCount() {
        return this.completedCount;
    }

    public Integer errorCount() {
        return this.errorCount;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Region());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.expiresAfter(), other.expiresAfter()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.requestedDateTime(), other.requestedDateTime()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.outputS3Region(), other.outputS3Region()) && Objects.equals(this.outputS3BucketName(), other.outputS3BucketName()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.targetCount(), other.targetCount()) && Objects.equals(this.completedCount(), other.completedCount()) && Objects.equals(this.errorCount(), other.errorCount()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.notificationConfig(), other.notificationConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.commandId() != null) {
            sb.append("CommandId: ").append(this.commandId()).append(",");
        }
        if (this.documentName() != null) {
            sb.append("DocumentName: ").append(this.documentName()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.expiresAfter() != null) {
            sb.append("ExpiresAfter: ").append(this.expiresAfter()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.targets() != null) {
            sb.append("Targets: ").append(this.targets()).append(",");
        }
        if (this.requestedDateTime() != null) {
            sb.append("RequestedDateTime: ").append(this.requestedDateTime()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(this.outputS3Region()).append(",");
        }
        if (this.outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(this.outputS3BucketName()).append(",");
        }
        if (this.outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(this.outputS3KeyPrefix()).append(",");
        }
        if (this.maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.maxConcurrency()).append(",");
        }
        if (this.maxErrors() != null) {
            sb.append("MaxErrors: ").append(this.maxErrors()).append(",");
        }
        if (this.targetCount() != null) {
            sb.append("TargetCount: ").append(this.targetCount()).append(",");
        }
        if (this.completedCount() != null) {
            sb.append("CompletedCount: ").append(this.completedCount()).append(",");
        }
        if (this.errorCount() != null) {
            sb.append("ErrorCount: ").append(this.errorCount()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.notificationConfig() != null) {
            sb.append("NotificationConfig: ").append(this.notificationConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.of(clazz.cast(this.commandId()));
            }
            case "DocumentName": {
                return Optional.of(clazz.cast(this.documentName()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "ExpiresAfter": {
                return Optional.of(clazz.cast(this.expiresAfter()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "InstanceIds": {
                return Optional.of(clazz.cast(this.instanceIds()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "RequestedDateTime": {
                return Optional.of(clazz.cast(this.requestedDateTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "OutputS3Region": {
                return Optional.of(clazz.cast(this.outputS3Region()));
            }
            case "OutputS3BucketName": {
                return Optional.of(clazz.cast(this.outputS3BucketName()));
            }
            case "OutputS3KeyPrefix": {
                return Optional.of(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "MaxConcurrency": {
                return Optional.of(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.of(clazz.cast(this.maxErrors()));
            }
            case "TargetCount": {
                return Optional.of(clazz.cast(this.targetCount()));
            }
            case "CompletedCount": {
                return Optional.of(clazz.cast(this.completedCount()));
            }
            case "ErrorCount": {
                return Optional.of(clazz.cast(this.errorCount()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "NotificationConfig": {
                return Optional.of(clazz.cast(this.notificationConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String commandId;
        private String documentName;
        private String comment;
        private Instant expiresAfter;
        private Map<String, List<String>> parameters;
        private List<String> instanceIds;
        private List<Target> targets;
        private Instant requestedDateTime;
        private String status;
        private String statusDetails;
        private String outputS3Region;
        private String outputS3BucketName;
        private String outputS3KeyPrefix;
        private String maxConcurrency;
        private String maxErrors;
        private Integer targetCount;
        private Integer completedCount;
        private Integer errorCount;
        private String serviceRole;
        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Command model) {
            this.commandId(model.commandId);
            this.documentName(model.documentName);
            this.comment(model.comment);
            this.expiresAfter(model.expiresAfter);
            this.parameters(model.parameters);
            this.instanceIds(model.instanceIds);
            this.targets(model.targets);
            this.requestedDateTime(model.requestedDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.outputS3Region(model.outputS3Region);
            this.outputS3BucketName(model.outputS3BucketName);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.targetCount(model.targetCount);
            this.completedCount(model.completedCount);
            this.errorCount(model.errorCount);
            this.serviceRole(model.serviceRole);
            this.notificationConfig(model.notificationConfig);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getExpiresAfter() {
            return this.expiresAfter;
        }

        @Override
        public final Builder expiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public final void setExpiresAfter(Instant expiresAfter) {
            this.expiresAfter = expiresAfter;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Instant getRequestedDateTime() {
            return this.requestedDateTime;
        }

        @Override
        public final Builder requestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            return this;
        }

        public final void setRequestedDateTime(Instant requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getOutputS3Region() {
            return this.outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return this.outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        public final Integer getCompletedCount() {
            return this.completedCount;
        }

        @Override
        public final Builder completedCount(Integer completedCount) {
            this.completedCount = completedCount;
            return this;
        }

        public final void setCompletedCount(Integer completedCount) {
            this.completedCount = completedCount;
        }

        public final Integer getErrorCount() {
            return this.errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final NotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        public Command build() {
            return new Command(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Command> {
        public Builder commandId(String var1);

        public Builder documentName(String var1);

        public Builder comment(String var1);

        public Builder expiresAfter(Instant var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder requestedDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(CommandStatus var1);

        public Builder statusDetails(String var1);

        public Builder outputS3Region(String var1);

        public Builder outputS3BucketName(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder targetCount(Integer var1);

        public Builder completedCount(Integer var1);

        public Builder errorCount(Integer var1);

        public Builder serviceRole(String var1);

        public Builder notificationConfig(NotificationConfig var1);

        default public Builder notificationConfig(Consumer<NotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((NotificationConfig)((NotificationConfig.Builder)NotificationConfig.builder().apply(notificationConfig)).build());
        }
    }
}

