/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;

@SdkInternalApi
public class SeveritySummaryMarshaller {
    private static final MarshallingInfo<Integer> CRITICALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CriticalCount").build();
    private static final MarshallingInfo<Integer> HIGHCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HighCount").build();
    private static final MarshallingInfo<Integer> MEDIUMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediumCount").build();
    private static final MarshallingInfo<Integer> LOWCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LowCount").build();
    private static final MarshallingInfo<Integer> INFORMATIONALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InformationalCount").build();
    private static final MarshallingInfo<Integer> UNSPECIFIEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnspecifiedCount").build();
    private static final SeveritySummaryMarshaller INSTANCE = new SeveritySummaryMarshaller();

    public static SeveritySummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SeveritySummary severitySummary, ProtocolMarshaller protocolMarshaller) {
        if (severitySummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)severitySummary.criticalCount(), CRITICALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.highCount(), HIGHCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.mediumCount(), MEDIUMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.lowCount(), LOWCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.informationalCount(), INFORMATIONALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)severitySummary.unspecifiedCount(), UNSPECIFIEDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

