/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.NotificationConfig;

@SdkInternalApi
public class NotificationConfigMarshaller {
    private static final MarshallingInfo<String> NOTIFICATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationArn").build();
    private static final MarshallingInfo<List> NOTIFICATIONEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationEvents").build();
    private static final MarshallingInfo<String> NOTIFICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationType").build();
    private static final NotificationConfigMarshaller INSTANCE = new NotificationConfigMarshaller();

    public static NotificationConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationConfig notificationConfig, ProtocolMarshaller protocolMarshaller) {
        if (notificationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)notificationConfig.notificationArn(), NOTIFICATIONARN_BINDING);
            protocolMarshaller.marshall(notificationConfig.notificationEventsStrings(), NOTIFICATIONEVENTS_BINDING);
            protocolMarshaller.marshall((Object)notificationConfig.notificationTypeString(), NOTIFICATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

