/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecution;

@SdkInternalApi
public class MaintenanceWindowExecutionMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MaintenanceWindowExecutionMarshaller INSTANCE = new MaintenanceWindowExecutionMarshaller();

    public static MaintenanceWindowExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowExecution maintenanceWindowExecution, ProtocolMarshaller protocolMarshaller) {
        if (maintenanceWindowExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.windowExecutionId(), WINDOWEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.statusDetails(), STATUSDETAILS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowExecution.endTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

