/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Command;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;

public final class ListCommandsPaginator
implements SdkIterable<ListCommandsResponse> {
    private final SSMClient client;
    private final ListCommandsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCommandsPaginator(SSMClient client, ListCommandsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandsResponseFetcher();
    }

    public Iterator<ListCommandsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Command> commands() {
        Function<ListCommandsResponse, Iterator> getIterator = response -> response != null ? response.commands().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListCommandsResponseFetcher
    implements NextPageFetcher<ListCommandsResponse> {
        private ListCommandsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCommandsResponse nextPage(ListCommandsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandsPaginator.this.client.listCommands(ListCommandsPaginator.this.firstRequest);
            }
            return ListCommandsPaginator.this.client.listCommands((ListCommandsRequest)((Object)ListCommandsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

