/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;

public final class ListAssociationsPaginator
implements SdkIterable<ListAssociationsResponse> {
    private final SSMClient client;
    private final ListAssociationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAssociationsPaginator(SSMClient client, ListAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public Iterator<ListAssociationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Association> associations() {
        Function<ListAssociationsResponse, Iterator> getIterator = response -> response != null ? response.associations().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListAssociationsResponseFetcher
    implements NextPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAssociationsResponse nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsPaginator.this.client.listAssociations(ListAssociationsPaginator.this.firstRequest);
            }
            return ListAssociationsPaginator.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

