/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ComplianceExecutionSummary;
import software.amazon.awssdk.services.ssm.model.ComplianceItemEntry;
import software.amazon.awssdk.services.ssm.model.ComplianceItemEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutComplianceItemsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutComplianceItemsRequest> {
    private final String resourceId;
    private final String resourceType;
    private final String complianceType;
    private final ComplianceExecutionSummary executionSummary;
    private final List<ComplianceItemEntry> items;
    private final String itemContentHash;

    private PutComplianceItemsRequest(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.complianceType = builder.complianceType;
        this.executionSummary = builder.executionSummary;
        this.items = builder.items;
        this.itemContentHash = builder.itemContentHash;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String complianceType() {
        return this.complianceType;
    }

    public ComplianceExecutionSummary executionSummary() {
        return this.executionSummary;
    }

    public List<ComplianceItemEntry> items() {
        return this.items;
    }

    public String itemContentHash() {
        return this.itemContentHash;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemContentHash());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutComplianceItemsRequest)) {
            return false;
        }
        PutComplianceItemsRequest other = (PutComplianceItemsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.complianceType(), other.complianceType()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.items(), other.items()) && Objects.equals(this.itemContentHash(), other.itemContentHash());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.complianceType() != null) {
            sb.append("ComplianceType: ").append(this.complianceType()).append(",");
        }
        if (this.executionSummary() != null) {
            sb.append("ExecutionSummary: ").append(this.executionSummary()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (this.itemContentHash() != null) {
            sb.append("ItemContentHash: ").append(this.itemContentHash()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "ComplianceType": {
                return Optional.of(clazz.cast(this.complianceType()));
            }
            case "ExecutionSummary": {
                return Optional.of(clazz.cast(this.executionSummary()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
            case "ItemContentHash": {
                return Optional.of(clazz.cast(this.itemContentHash()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String complianceType;
        private ComplianceExecutionSummary executionSummary;
        private List<ComplianceItemEntry> items;
        private String itemContentHash;

        private BuilderImpl() {
        }

        private BuilderImpl(PutComplianceItemsRequest model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.complianceType(model.complianceType);
            this.executionSummary(model.executionSummary);
            this.items(model.items);
            this.itemContentHash(model.itemContentHash);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        public final ComplianceExecutionSummary.Builder getExecutionSummary() {
            return this.executionSummary != null ? this.executionSummary.toBuilder() : null;
        }

        @Override
        public final Builder executionSummary(ComplianceExecutionSummary executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(ComplianceExecutionSummary.BuilderImpl executionSummary) {
            this.executionSummary = executionSummary != null ? executionSummary.build() : null;
        }

        public final Collection<ComplianceItemEntry.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(ComplianceItemEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<ComplianceItemEntry> items) {
            this.items = ComplianceItemEntryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ComplianceItemEntry ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<ComplianceItemEntry.BuilderImpl> items) {
            this.items = ComplianceItemEntryListCopier.copyFromBuilder(items);
        }

        public final String getItemContentHash() {
            return this.itemContentHash;
        }

        @Override
        public final Builder itemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
            return this;
        }

        public final void setItemContentHash(String itemContentHash) {
            this.itemContentHash = itemContentHash;
        }

        public PutComplianceItemsRequest build() {
            return new PutComplianceItemsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutComplianceItemsRequest> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder complianceType(String var1);

        public Builder executionSummary(ComplianceExecutionSummary var1);

        default public Builder executionSummary(Consumer<ComplianceExecutionSummary.Builder> executionSummary) {
            return this.executionSummary((ComplianceExecutionSummary)((ComplianceExecutionSummary.Builder)ComplianceExecutionSummary.builder().apply(executionSummary)).build());
        }

        public Builder items(Collection<ComplianceItemEntry> var1);

        public Builder items(ComplianceItemEntry ... var1);

        public Builder itemContentHash(String var1);
    }
}

