/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.PatchFilterKey;
import software.amazon.awssdk.services.ssm.model.PatchFilterValueListCopier;
import software.amazon.awssdk.services.ssm.transform.PatchFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PatchFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchFilter> {
    private final String key;
    private final List<String> values;

    private PatchFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    public PatchFilterKey key() {
        return PatchFilterKey.fromValue(this.key);
    }

    public String keyString() {
        return this.key;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilter)) {
            return false;
        }
        PatchFilter other = (PatchFilter)obj;
        return Objects.equals(this.keyString(), other.keyString()) && Objects.equals(this.values(), other.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyString() != null) {
            sb.append("Key: ").append(this.keyString()).append(",");
        }
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.keyString()));
            }
            case "Values": {
                return Optional.of(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilter model) {
            this.key(model.key);
            this.values(model.values);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(PatchFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PatchFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = PatchFilterValueListCopier.copy(values);
        }

        public PatchFilter build() {
            return new PatchFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchFilter> {
        public Builder key(String var1);

        public Builder key(PatchFilterKey var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

