/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InstanceAssociation;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEffectiveInstanceAssociationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEffectiveInstanceAssociationsResponse> {
    private final List<InstanceAssociation> associations;
    private final String nextToken;

    private DescribeEffectiveInstanceAssociationsResponse(BuilderImpl builder) {
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceAssociation> associations() {
        return this.associations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEffectiveInstanceAssociationsResponse)) {
            return false;
        }
        DescribeEffectiveInstanceAssociationsResponse other = (DescribeEffectiveInstanceAssociationsResponse)((Object)obj);
        return Objects.equals(this.associations(), other.associations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associations() != null) {
            sb.append("Associations: ").append(this.associations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Associations": {
                return Optional.of(clazz.cast(this.associations()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceAssociation> associations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEffectiveInstanceAssociationsResponse model) {
            this.associations(model.associations);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociation.Builder> getAssociations() {
            return this.associations != null ? (Collection)this.associations.stream().map(InstanceAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<InstanceAssociation> associations) {
            this.associations = InstanceAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(InstanceAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<InstanceAssociation.BuilderImpl> associations) {
            this.associations = InstanceAssociationListCopier.copyFromBuilder(associations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEffectiveInstanceAssociationsResponse build() {
            return new DescribeEffectiveInstanceAssociationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEffectiveInstanceAssociationsResponse> {
        public Builder associations(Collection<InstanceAssociation> var1);

        public Builder associations(InstanceAssociation ... var1);

        public Builder nextToken(String var1);
    }
}

