/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.S3OutputUrl;

@SdkInternalApi
public class S3OutputUrlMarshaller {
    private static final MarshallingInfo<String> OUTPUTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUrl").build();
    private static final S3OutputUrlMarshaller INSTANCE = new S3OutputUrlMarshaller();

    public static S3OutputUrlMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3OutputUrl s3OutputUrl, ProtocolMarshaller protocolMarshaller) {
        if (s3OutputUrl == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3OutputUrl.outputUrl(), OUTPUTURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

