/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchComplianceData;

@SdkInternalApi
public class PatchComplianceDataMarshaller {
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").build();
    private static final MarshallingInfo<String> KBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KBId").build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Instant> INSTALLEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstalledTime").build();
    private static final PatchComplianceDataMarshaller INSTANCE = new PatchComplianceDataMarshaller();

    public static PatchComplianceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchComplianceData patchComplianceData, ProtocolMarshaller protocolMarshaller) {
        if (patchComplianceData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)patchComplianceData.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.kbId(), KBID_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.severity(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)patchComplianceData.installedTime(), INSTALLEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

