/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;

public class LoggingInfoUnmarshaller
implements Unmarshaller<LoggingInfo, JsonUnmarshallerContext> {
    private static final LoggingInfoUnmarshaller INSTANCE = new LoggingInfoUnmarshaller();

    public LoggingInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        LoggingInfo.Builder loggingInfoBuilder = LoggingInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3BucketName", targetDepth)) {
                    context.nextToken();
                    loggingInfoBuilder.s3BucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    loggingInfoBuilder.s3KeyPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Region", targetDepth)) {
                    context.nextToken();
                    loggingInfoBuilder.s3Region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LoggingInfo)loggingInfoBuilder.build();
    }

    public static LoggingInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

