/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentVersionInfo;

@SdkInternalApi
public class DocumentVersionInfoMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").build();
    private static final MarshallingInfo<Boolean> ISDEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsDefaultVersion").build();
    private static final DocumentVersionInfoMarshaller INSTANCE = new DocumentVersionInfoMarshaller();

    public static DocumentVersionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentVersionInfo documentVersionInfo, ProtocolMarshaller protocolMarshaller) {
        if (documentVersionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentVersionInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentVersionInfo.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentVersionInfo.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)documentVersionInfo.isDefaultVersion(), ISDEFAULTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

